#################
# calculate the power of a two-stage design for given
# values of m, n, mu, i, j, rho, rho0, and the desired
# number of true markers to be detected
#################

twostage.power <- function(n=100, m=100, mu=0.345, mu.loc=50,
                           i.value=0.10, j.value=0.50, 
                           rho=0, rho0=0, true.needed=1, nsim = 1000){

  n1 <- round(n * j.value)
  n2 <- n - n1
  m1.value <- round(m * i.value)
  power <- 0
  ntrue <- length(mu.loc)
  if( true.needed > ntrue ){
    print(paste("ntrue is", ntrue))
    print(paste("true.needed is", true.needed))
    print("true.needed cannot be larger than ntrue")
  }
  else{
    mu.star <- rep(0,m)
    if( rho > 0){
      tt <- matrix(0, nrow=length(mu.loc), ncol=m)
      for(i in 1:length(mu.loc)){
        tt[i,] <- mu * rho^abs((1:m)-mu.loc[i])
      }
      mu.star <- apply(tt,2,sum)
    }
    else{
      mu.star[mu.loc] <- mu
    }

    power <- 0
    zzz <- .Fortran("pw2stg",
                     m=as.integer(m),
                     m1=as.integer(m1.value),
                     n1=as.integer(n1),
                     n2=as.integer(n2),
                     x1=double(m),
                     x2=double(m),
                     muvec=as.double(mu.star),
                     nmu=as.integer(ntrue),
                     muloc=as.integer(mu.loc),
                     rho0=as.double(rho0),
                     rho1=as.double(rho),
                     nsel=as.integer(true.needed),
                     nsim=as.integer(nsim),
                     pow=double(1),
                     tmp=double(m),
                     ord1=integer(m),
                     rnk1=integer(m))
    return(zzz$pow)
  }
}

